clc; close all; clear;

%%
MESHSIZE = 2; % [mm]

DIR_XF = '.'; % Xfdtdt@C(.xf)̃pX
DIR_MAT = '../Phantoms/Class3/exactDebyeModel_coarse.mat'; % Matlabt@C(.mat)̃pX

% }eAݒ
RT = 1.5e-11; % [sec] % Relaxation time

% Au[V
ABLATION = 0; % 0->raw, 1->ablation
FACTOR = 0.6;

R_aa = 8; % [mm] % x/y-radius
R_bb = 10; % [mm] % z-radius

TRANS_x = 60; % [mm] % location of ablation zone
TRANS_y = 56; % [mm]
TRANS_z = 35; % [mm]

% wi}(})
SKIPMATERIAL_cndSta = 0.0;
SKIPMATERIAL_prmInf = 2.60;
SKIPMATERIAL_prmSta = 2.60;

% ڐA
DENOMINATOR = 1; % 
NUMERATOR = 1; % p[gI

% f̕ێ(㏑邩)
KEEPMODEL = 1; % 0->delete, 1->keep


% f̗ʎq
QUAN_cndSta = 1; % _ȉx
QUAN_prmInf = 0;
QUAN_prmSta = 0;

% XCXʁFvr[iXFDTDɂ͉eȂj
SLICE_x = TRANS_x;
SLICE_y = TRANS_y;
SLICE_z = TRANS_z;

% f̉
INVISIBLE = 0; % 0->visible, 1->inbisible(low-memory??)

%% load
totalTic = tic; loadTic = tic;

DIR_XF = [DIR_XF,'/Project.xml'];
fileID = fopen(DIR_XF,'rt');
fprintf('Loading...');

i = 1;
while 1
    readChar = fgetl(fileID); %% s폜ǂݍ -> 񌟍̈
    readCode(i,1) = string(readChar);
    if readChar == -1
        fprintf('DONE\n');
        break;
    end
    i = i+1;
end
codeLine = i;
fclose(fileID);

for i = 1:codeLine%
    if readCode(i,1) == '    </Scripts>'
        matBeginIndex = i+1;
    elseif readCode(i,1) == '    </MaterialList>'
        matEndIndex = i;
    elseif readCode(i,1) == '    </CurrentCuttingPlane>'
        objBeginIndex = i+1;
    elseif readCode(i,1) == '    </Geometry>'
        objEndIndex = i;
    end
end

load(DIR_MAT); 
loadTime = toc(loadTic);

totalCells = length(cndSta(:,1,1))*length(cndSta(1,:,1)) ...
    *(floor(length(cndSta(1,1,:))*NUMERATOR/DENOMINATOR) ...
    -ceil(length(cndSta(1,1,:))*(NUMERATOR-0.9999999999)/DENOMINATOR)+1);

mesh = zeros(length(cndSta(:,1,1)),length(cndSta(1,:,1)),length(cndSta(1,1,:)));
mesh(prmSta==SKIPMATERIAL_prmSta) = 99;

cndSta = round(cndSta,QUAN_cndSta);
prmInf = round(prmInf,QUAN_prmInf);
prmSta = round(prmSta,QUAN_prmSta);

% ablation
switch ABLATION
    case 1
        for z = 1:length(cndSta(1,1,:))
            for y = 1:length(cndSta(:,1,1))
                for x = 1:length(cndSta(1,:,1))
                    if ((x-TRANS_x/MESHSIZE)/(R_aa/MESHSIZE))^2 ...
                            +((y-TRANS_y/MESHSIZE)/(R_aa/MESHSIZE))^2 ...
                            +((z-TRANS_z/MESHSIZE)/(R_bb/MESHSIZE))^2 <= 1
                        cndSta(x,y,z) = cndSta(x,y,z)*FACTOR;
                        prmInf(x,y,z) = prmInf(x,y,z)*FACTOR;
                        prmSta(x,y,z) = prmSta(x,y,z)*FACTOR;
                    end
                end
            end
        end
end

switch NUMERATOR % model preview
    case 1
        view_cndSta = zeros(length(cndSta(1,:,1)),length(cndSta(:,1,1)),length(cndSta(1,1,:)));
        view_prmInf = view_cndSta; view_prmSta = view_cndSta; view_mesh = view_cndSta;
        for i = 1:length(cndSta(1,1,:))
            view_cndSta(:,:,i) = cndSta(:,:,i)';
            view_prmInf(:,:,i) = prmInf(:,:,i)';
            view_prmSta(:,:,i) = prmSta(:,:,i)';
            view_mesh(:,:,i) = mesh(:,:,i)';
        end
        view_cndSta(view_mesh(:,:,:) == 99) = NaN;
        view_prmInf(view_mesh(:,:,:) == 99) = NaN;
        view_prmSta(view_mesh(:,:,:) == 99) = NaN;
        [X,Y,Z] = meshgrid(1:length(cndSta(:,1,1)), 1:length(cndSta(1,:,1)), 1:length(cndSta(1,1,:)));

        figure()
        theta = (1:3600)./3600*2*pi;
        xx = TRANS_x + R_aa.*cos(theta);
        yy = repmat(TRANS_y,1,3600);
        zz = TRANS_z + R_bb.*sin(theta);
        subplot(2,3,1)
            h1 = slice(X.*MESHSIZE, Y.*MESHSIZE, Z.*MESHSIZE, view_prmInf, [], SLICE_y, []); h1.EdgeColor = 'none';
            axis equal; daspect([1,1,1]); view(0,0); colorbar;
            hold on; plot3(xx,yy,zz,'-w');
            set(gca, 'FontName','Times','FontSize',14);
            title('prmInf'); xlabel('x','FontSize',18); ylabel('y','FontSize',18); zlabel('z','FontSize',18);
        xx = TRANS_x + R_aa.*cos(theta);
        yy = TRANS_y + R_aa.*sin(theta);
        zz = repmat(TRANS_z,1,3600);
        subplot(2,3,2)
            h2 = slice(X.*MESHSIZE, Y.*MESHSIZE, Z.*MESHSIZE, view_prmInf, [], [], SLICE_z); h2.EdgeColor = 'none';
            axis equal; daspect([1,1,1]); view(0,90); colorbar;
            hold on; plot3(xx,yy,zz,'-w');
            set(gca, 'FontName','Times','FontSize',14);
            title('prmInf'); xlabel('x','FontSize',18); ylabel('y','FontSize',18); zlabel('z','FontSize',18);
        xx = repmat(TRANS_x,1,3600);
        yy = TRANS_y + R_aa.*cos(theta);
        zz = TRANS_z + R_bb.*sin(theta);
        subplot(2,3,3)
            h3 = slice(X.*MESHSIZE, Y.*MESHSIZE, Z.*MESHSIZE, view_prmInf, SLICE_x, [], []); h3.EdgeColor = 'none';
            axis equal; daspect([1,1,1]); view(90,0); colorbar;
            hold on; plot3(xx,yy,zz,'-w');
            set(gca, 'FontName','Times','FontSize',14);
            title('prmInf'); xlabel('x','FontSize',18); ylabel('y','FontSize',18); zlabel('z','FontSize',18);
        subplot(2,3,4)
            h3 = slice(X.*MESHSIZE, Y.*MESHSIZE, Z.*MESHSIZE, view_cndSta, SLICE_x, [], []); h3.EdgeColor = 'none';
            axis equal; daspect([1,1,1]); view(90,0); colorbar;
            hold on; plot3(xx,yy,zz,'-w');
            set(gca, 'FontName','Times','FontSize',14);
            title('cndSta'); xlabel('x','FontSize',18); ylabel('y','FontSize',18); zlabel('z','FontSize',18);
        subplot(2,3,5)
            h3 = slice(X.*MESHSIZE, Y.*MESHSIZE, Z.*MESHSIZE, view_prmSta, SLICE_x, [], []); h3.EdgeColor = 'none';
            axis equal; daspect([1,1,1]); view(90,0);  colorbar;
            hold on; plot3(xx,yy,zz,'-w');
            set(gca, 'FontName','Times','FontSize',14);
            title('prmSta'); xlabel('x','FontSize',18); ylabel('y','FontSize',18); zlabel('z','FontSize',18);

        fprintf('===== f =====\n');
        fprintf('MAT͗̈: x=%f, y=%f, z=%f\n', length(cndSta(:,1,1))*MESHSIZE, length(cndSta(1,:,1))*MESHSIZE, length(cndSta(1,1,:))*MESHSIZE);
        fprintf('XF͗̈: x=%f-%f, y=%f-%f, z=%f-%f\n', length(cndSta(:,1,1))*MESHSIZE/2-100, length(cndSta(:,1,1))*MESHSIZE/2+100, length(cndSta(1,:,1))*MESHSIZE/2-100, length(cndSta(1,:,1))*MESHSIZE/2+100, 0, length(cndSta(1,1,:))*MESHSIZE+30);
        fprintf('Mʒu: x=%f, y=%f, z=%f\n', TRANS_x, TRANS_y, TRANS_z);
        fprintf('=====================\n');
        fprintf('>> ̃fMAT2XFϊJn܂(Press any key to continue...)\n');
        pause;
end

max_prmInf = max(prmInf,[],3);
max_prmInf = max(max_prmInf,[],2);
max_prmInf = max(max_prmInf,[],1);
prmColorLevel = linspace(0, max_prmInf, 64)';
colorLevel = parula.*255;

%% convert Material
convMatTic = tic; perCount = 1;

switch KEEPMODEL
    case 0
        fprintf(['>> "',DIR_XF,'"̃f͕ێ܂(Press any key to continue...)\n']);
        pause;
        totalLineCounts = matBeginIndex-1;
        outputCode(:,1) = readCode(1:totalLineCounts,1);
            totalLineCounts = totalLineCounts+1;
        outputCode(totalLineCounts,1) = readCode(matBeginIndex,1);
            totalLineCounts = totalLineCounts+1;
        outputCode(totalLineCounts,1) = readCode(matBeginIndex+1,1);
            totalLineCounts = totalLineCounts+1;
    case 1
        fprintf(['>> "',DIR_XF,'"̃fێ܂(Press any key to continue...)\n']);
        pause;
        totalLineCounts = matEndIndex-2;
        outputCode(:,1) = readCode(1:totalLineCounts,1);
            totalLineCounts = totalLineCounts+1;
end

if NUMERATOR == 1
    registeredMat = double.empty(0,4);
    memoMat = zeros(length(cndSta(:,1,1)),length(cndSta(1,:,1)),length(cndSta(1,1,:)));
else
    load('./registeredMat.mat');
    load('./memoMat.mat');
end

matVar = 2e9; matVar_bak = matVar; loopCount = 1;
for kk = ceil(length(cndSta(1,1,:))*(NUMERATOR-0.9999999999)/DENOMINATOR):floor(length(cndSta(1,1,:))*NUMERATOR/DENOMINATOR)
    for jj = 1:length(cndSta(1,:,1))
        for ii = 1:length(cndSta(:,1,1))
            if mesh(ii,jj,kk) ~= 99
                
                FINDMAT = 0;
                if isempty(registeredMat) == 0
                    for i = 1:length(registeredMat(:,1))
                        if cndSta(ii,jj,kk) == registeredMat(i,2) && prmInf(ii,jj,kk) == registeredMat(i,3) && prmSta(ii,jj,kk) == registeredMat(i,4)
                            FINDMAT = 1;
                            break;
                        end
                    end
                end

                switch FINDMAT
                    case 1
                        memoMat(ii,jj,kk) = registeredMat(i,1);
                    case 0
                        registeredMat(length(registeredMat(:,1))+1,1) = matVar;
                        memoMat(ii,jj,kk) = matVar;
                        registeredMat(length(registeredMat(:,1)),2) = cndSta(ii,jj,kk);
                        registeredMat(length(registeredMat(:,1)),3) = prmInf(ii,jj,kk);
                        registeredMat(length(registeredMat(:,1)),4) = prmSta(ii,jj,kk);
                
                        outputCode(totalLineCounts,1) = ['        <MaterialDefinition ptrID="', num2str(matVar), '" subjectID="', num2str(matVar+1), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['          <Material sname="mat', num2str(ii), '_', num2str(jj), '_', num2str(kk), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            <DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['              <DataSet ptrID="', num2str(matVar+2), '" subjectID="', num2str(matVar+3), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSetProxy DataSetId="E - ConductivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <Subject ptrID="', num2str(matVar+4), '" subjectID="', num2str(matVar+5), '" masterID="', num2str(matVar+101), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSetProxy DataSetId="E - ConductivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <Subject ptrID="', num2str(matVar+6), '" subjectID="', num2str(matVar+7), '" masterID="', num2str(matVar+108), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSetProxy DataSetId="ConductivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Subject ptrID="', num2str(matVar+8), '" subjectID="', num2str(matVar+9), '" masterID="', num2str(matVar+115), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            <ElectricDebyeDrudeDataSet ElectricParametersType="Conductivity" sname="Conductivity" DataSetId="ConductivityVsFrequency" UnitClass="SCALAR">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                <Dimension ptrID="', num2str(matVar+10), '" subjectID="', num2str(matVar+11), '" masterID="', num2str(matVar+116), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <ContinuousDimension sname="Frequency" DataSetId="Frequency" UnitClass="FREQUENCY"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Dimension>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <Conductivity ptrID="', num2str(matVar+12), '" subjectID="', num2str(matVar+13), '" masterID="', num2str(matVar+120), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                  <Formula typeid="6" type="Double" value="', num2str(cndSta(ii,jj,kk)), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </Conductivity>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <InfiniteFrequencyRelativePermittivity ptrID="', num2str(matVar+14), '" subjectID="', num2str(matVar+15), '" masterID="', num2str(matVar+121), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                  <Formula typeid="6" type="Double" value="', num2str(prmInf(ii,jj,kk)), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </InfiniteFrequencyRelativePermittivity>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <NumberOfPoles ptrID="', num2str(matVar+16), '" subjectID="', num2str(matVar+17), '" masterID="', num2str(matVar+122), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <Formula typeid="2" type="Int" value="1"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </NumberOfPoles>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime1 ptrID="', num2str(matVar+18), '" subjectID="', num2str(matVar+19), '" masterID="', num2str(matVar+123), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                  <Formula typeid="10" type="String" value="', num2str(RT), ' s"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </RelaxationTime1>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime2 ptrID="', num2str(matVar+20), '" subjectID="', num2str(matVar+21), '" masterID="', num2str(matVar+124), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </RelaxationTime2>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime3 ptrID="', num2str(matVar+22), '" subjectID="', num2str(matVar+23), '" masterID="', num2str(matVar+125), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </RelaxationTime3>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity1 ptrID="', num2str(matVar+24), '" subjectID="', num2str(matVar+25), '" masterID="', num2str(matVar+126), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                  <Formula typeid="6" type="Double" value="', num2str(prmSta(ii,jj,kk)), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </StaticRelativePermittivity1>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity2 ptrID="', num2str(matVar+26), '" subjectID="', num2str(matVar+27), '" masterID="', num2str(matVar+127), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="1"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </StaticRelativePermittivity2>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity3 ptrID="', num2str(matVar+28), '" subjectID="', num2str(matVar+29), '" masterID="', num2str(matVar+128), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="1"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                                </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </StaticRelativePermittivity3>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </ElectricDebyeDrudeDataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </DataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['              <DataSet ptrID="', num2str(matVar+30), '" subjectID="', num2str(matVar+31), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSetProxy DataSetId="E - Frequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <Subject ptrID="', num2str(matVar+32), '" subjectID="', num2str(matVar+33), '" masterID="', num2str(matVar+102), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSetProxy DataSetId="E - Frequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <Subject ptrID="', num2str(matVar+34), '" subjectID="', num2str(matVar+35), '" masterID="', num2str(matVar+109), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSetProxy DataSetId="Frequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Subject ptrID="', num2str(matVar+36), '" subjectID="', num2str(matVar+11), '" masterID="', num2str(matVar+116), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </DataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['              <DataSet ptrID="', num2str(matVar+37), '" subjectID="', num2str(matVar+38), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSetProxy DataSetId="E - ImaginaryPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <Subject ptrID="', num2str(matVar+39), '" subjectID="', num2str(matVar+40), '" masterID="', num2str(matVar+103), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSetProxy DataSetId="E - ImaginaryPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <Subject ptrID="', num2str(matVar+41), '" subjectID="', num2str(matVar+42), '" masterID="', num2str(matVar+110), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSetProxy DataSetId="ImaginaryPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Subject ptrID="', num2str(matVar+43), '" subjectID="', num2str(matVar+44), '" masterID="', num2str(matVar+117), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            <ElectricDebyeDrudeDataSet ElectricParametersType="ImaginaryPartComplexPermittivity" sname="Imaginary Part Complex Permittivity" DataSetId="ImaginaryPartComplexPermittivityVsFrequency" UnitClass="SCALAR">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                <Dimension ptrID="', num2str(matVar+45), '" subjectID="', num2str(matVar+11), '" masterID="', num2str(matVar+116), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <Conductivity ptrID="', num2str(matVar+46), '" subjectID="', num2str(matVar+13), '" masterID="', num2str(matVar+120), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <InfiniteFrequencyRelativePermittivity ptrID="', num2str(matVar+47), '" subjectID="', num2str(matVar+15), '" masterID="', num2str(matVar+121), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <NumberOfPoles ptrID="', num2str(matVar+48), '" subjectID="', num2str(matVar+17), '" masterID="', num2str(matVar+122), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime1 ptrID="', num2str(matVar+49), '" subjectID="', num2str(matVar+19), '" masterID="', num2str(matVar+123), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime2 ptrID="', num2str(matVar+50), '" subjectID="', num2str(matVar+21), '" masterID="', num2str(matVar+124), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime3 ptrID="', num2str(matVar+51), '" subjectID="', num2str(matVar+23), '" masterID="', num2str(matVar+125), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity1 ptrID="', num2str(matVar+52), '" subjectID="', num2str(matVar+25), '" masterID="', num2str(matVar+126), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity2 ptrID="', num2str(matVar+53), '" subjectID="', num2str(matVar+27), '" masterID="', num2str(matVar+127), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity3 ptrID="', num2str(matVar+54), '" subjectID="', num2str(matVar+29), '" masterID="', num2str(matVar+128), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </ElectricDebyeDrudeDataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </DataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['              <DataSet ptrID="', num2str(matVar+55), '" subjectID="', num2str(matVar+56), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSetProxy DataSetId="E - RealPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <Subject ptrID="', num2str(matVar+57), '" subjectID="', num2str(matVar+58), '" masterID="', num2str(matVar+104), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSetProxy DataSetId="E - RealPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <Subject ptrID="', num2str(matVar+59), '" subjectID="', num2str(matVar+60), '" masterID="', num2str(matVar+111), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSetProxy DataSetId="RealPartComplexPermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Subject ptrID="', num2str(matVar+61), '" subjectID="', num2str(matVar+62), '" masterID="', num2str(matVar+118), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            <ElectricDebyeDrudeDataSet ElectricParametersType="RealPartComplexPermittivity" sname="Real Part Complex Permittivity" DataSetId="RealPartComplexPermittivityVsFrequency" UnitClass="SCALAR">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                <Dimension ptrID="', num2str(matVar+63), '" subjectID="', num2str(matVar+11), '" masterID="', num2str(matVar+116), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <Conductivity ptrID="', num2str(matVar+64), '" subjectID="', num2str(matVar+13), '" masterID="', num2str(matVar+120), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <InfiniteFrequencyRelativePermittivity ptrID="', num2str(matVar+65), '" subjectID="', num2str(matVar+15), '" masterID="', num2str(matVar+121), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <NumberOfPoles ptrID="', num2str(matVar+66), '" subjectID="', num2str(matVar+17), '" masterID="', num2str(matVar+122), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime1 ptrID="', num2str(matVar+67), '" subjectID="', num2str(matVar+19), '" masterID="', num2str(matVar+123), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime2 ptrID="', num2str(matVar+68), '" subjectID="', num2str(matVar+21), '" masterID="', num2str(matVar+124), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime3 ptrID="', num2str(matVar+69), '" subjectID="', num2str(matVar+23), '" masterID="', num2str(matVar+125), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity1 ptrID="', num2str(matVar+70), '" subjectID="', num2str(matVar+25), '" masterID="', num2str(matVar+126), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity2 ptrID="', num2str(matVar+71), '" subjectID="', num2str(matVar+27), '" masterID="', num2str(matVar+127), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity3 ptrID="', num2str(matVar+72), '" subjectID="', num2str(matVar+29), '" masterID="', num2str(matVar+128), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </ElectricDebyeDrudeDataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </DataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['              <DataSet ptrID="', num2str(matVar+73), '" subjectID="', num2str(matVar+74), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSetProxy DataSetId="E - RelativePermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <Subject ptrID="', num2str(matVar+75), '" subjectID="', num2str(matVar+76), '" masterID="', num2str(matVar+105), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSetProxy DataSetId="E - RelativePermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <Subject ptrID="', num2str(matVar+77), '" subjectID="', num2str(matVar+78), '" masterID="', num2str(matVar+112), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSetProxy DataSetId="RelativePermittivityVsFrequency">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Subject ptrID="', num2str(matVar+79), '" subjectID="', num2str(matVar+80), '" masterID="', num2str(matVar+119), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            <ElectricDebyeDrudeDataSet ElectricParametersType="RelativePermittivity" sname="Relative permittivity" DataSetId="RelativePermittivityVsFrequency" UnitClass="SCALAR">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                                <Dimension ptrID="', num2str(matVar+81), '" subjectID="', num2str(matVar+11), '" masterID="', num2str(matVar+116), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <Conductivity ptrID="', num2str(matVar+82), '" subjectID="', num2str(matVar+13), '" masterID="', num2str(matVar+120), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <InfiniteFrequencyRelativePermittivity ptrID="', num2str(matVar+83), '" subjectID="', num2str(matVar+15), '" masterID="', num2str(matVar+121), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <NumberOfPoles ptrID="', num2str(matVar+84), '" subjectID="', num2str(matVar+17), '" masterID="', num2str(matVar+122), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime1 ptrID="', num2str(matVar+85), '" subjectID="', num2str(matVar+19), '" masterID="', num2str(matVar+123), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime2 ptrID="', num2str(matVar+86), '" subjectID="', num2str(matVar+21), '" masterID="', num2str(matVar+124), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <RelaxationTime3 ptrID="', num2str(matVar+87), '" subjectID="', num2str(matVar+23), '" masterID="', num2str(matVar+125), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity1 ptrID="', num2str(matVar+88), '" subjectID="', num2str(matVar+25), '" masterID="', num2str(matVar+126), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity2 ptrID="', num2str(matVar+89), '" subjectID="', num2str(matVar+27), '" masterID="', num2str(matVar+127), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                              <StaticRelativePermittivity3 ptrID="', num2str(matVar+90), '" subjectID="', num2str(matVar+29), '" masterID="', num2str(matVar+128), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </ElectricDebyeDrudeDataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Subject>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSetProxy>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </DataSet>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <MaterialAppearance ptrID="', num2str(matVar+91), '" subjectID="', num2str(matVar+92), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <BodyAppearance OldEdgeAppearance="false" OldVertexAppearance="false" OldFaceAppearance="true">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <FaceAppearance ptrID="', num2str(matVar+93), '" subjectID="', num2str(matVar+94), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <FaceAppearance Gloss="5" FaceStyle="Solid">';
                            totalLineCounts = totalLineCounts+1;

                        [~,colorInd] = min(abs(prmColorLevel(:,1)-prmInf(ii,jj,kk)));

                        outputCode(totalLineCounts,1) = ['                    <Color alpha="255" red="', num2str(round(colorLevel(colorInd,1))), '" blue="', num2str(round(colorLevel(colorInd,3))), '" green="', num2str(round(colorLevel(colorInd,2))), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <SpecularColor alpha="255" red="255" blue="255" green="255"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </FaceAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </FaceAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <EdgeAppearance ptrID="', num2str(matVar+95), '" subjectID="', num2str(matVar+96), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <LineAppearance Visibility="false" CustomLineStyle="None" CustomGlyphSize="8" LineStyle="Solid" LineWeight="1">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <Color alpha="255" red="', num2str(round(colorLevel(colorInd,1))), '" blue="', num2str(round(colorLevel(colorInd,3))), '" green="', num2str(round(colorLevel(colorInd,2))), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </LineAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </EdgeAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <VertexAppearance ptrID="', num2str(matVar+97), '" subjectID="', num2str(matVar+98), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <MarkerAppearance MarkerSize="1" Visibility="false" MarkerUnits="DefaultUnit" MarkerSymbol="FilledCircle">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <Color alpha="255" red="', num2str(round(colorLevel(colorInd,1))), '" blue="', num2str(round(colorLevel(colorInd,3))), '" green="', num2str(round(colorLevel(colorInd,2))), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </MarkerAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </VertexAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </BodyAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </MaterialAppearance>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <Details ptrID="', num2str(matVar+99), '" subjectID="', num2str(matVar+100), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <PhysicalMaterial sname="Material Details">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <DataSet ptrID="', num2str(matVar+101), '" subjectID="', num2str(matVar+5), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <DataSet ptrID="', num2str(matVar+102), '" subjectID="', num2str(matVar+33), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <DataSet ptrID="', num2str(matVar+103), '" subjectID="', num2str(matVar+40), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <DataSet ptrID="', num2str(matVar+104), '" subjectID="', num2str(matVar+58), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                  <DataSet ptrID="', num2str(matVar+105), '" subjectID="', num2str(matVar+76), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ElectricProperties ptrID="', num2str(matVar+106), '" subjectID="', num2str(matVar+107), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <ElectricIsotropic sname="Electric material properties">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <DataSet ptrID="', num2str(matVar+108), '" subjectID="', num2str(matVar+7), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <DataSet ptrID="', num2str(matVar+109), '" subjectID="', num2str(matVar+35), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <DataSet ptrID="', num2str(matVar+110), '" subjectID="', num2str(matVar+42), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <DataSet ptrID="', num2str(matVar+111), '" subjectID="', num2str(matVar+60), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <DataSet ptrID="', num2str(matVar+112), '" subjectID="', num2str(matVar+78), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <Parameters ptrID="', num2str(matVar+113), '" subjectID="', num2str(matVar+114), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      <ElectricDebyeDrudeParameters GCCalcMode="Automatic" sname="Electric Parameters">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <DataSet ptrID="', num2str(matVar+115), '" subjectID="', num2str(matVar+9), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <DataSet ptrID="', num2str(matVar+116), '" subjectID="', num2str(matVar+11), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <DataSet ptrID="', num2str(matVar+117), '" subjectID="', num2str(matVar+44), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <DataSet ptrID="', num2str(matVar+118), '" subjectID="', num2str(matVar+62), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <DataSet ptrID="', num2str(matVar+119), '" subjectID="', num2str(matVar+80), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </DataSets>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <Conductivity ptrID="', num2str(matVar+120), '" subjectID="', num2str(matVar+13), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <InfiniteFrequencyRelativePermittivity ptrID="', num2str(matVar+121), '" subjectID="', num2str(matVar+15), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <NumberOfPoles ptrID="', num2str(matVar+122), '" subjectID="', num2str(matVar+17), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <RelaxationTime1 ptrID="', num2str(matVar+123), '" subjectID="', num2str(matVar+19), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <RelaxationTime2 ptrID="', num2str(matVar+124), '" subjectID="', num2str(matVar+21), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <RelaxationTime3 ptrID="', num2str(matVar+125), '" subjectID="', num2str(matVar+23), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <StaticRelativePermittivity1 ptrID="', num2str(matVar+126), '" subjectID="', num2str(matVar+25), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <StaticRelativePermittivity2 ptrID="', num2str(matVar+127), '" subjectID="', num2str(matVar+27), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                        <StaticRelativePermittivity3 ptrID="', num2str(matVar+128), '" subjectID="', num2str(matVar+29), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </ElectricDebyeDrudeParameters>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </Parameters>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </ElectricIsotropic>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </ElectricProperties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <MagneticProperties ptrID="', num2str(matVar+129), '" subjectID="', num2str(matVar+130), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <MagneticFreespace sname="Magnetic material properties">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <FreespaceData ptrID="', num2str(matVar+131), '" subjectID="', num2str(matVar+132), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      <MagneticFreespaceParameters sname="Magnetic Parameters"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </FreespaceData>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </MagneticFreespace>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </MagneticProperties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </PhysicalMaterial>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </Details>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <PhysicalDetails ptrID="', num2str(matVar+133), '" subjectID="', num2str(matVar+134), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <PhysicalParameters version="1" TissueMaterial="false">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <Density ptrID="', num2str(matVar+135), '" subjectID="', num2str(matVar+136), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Density>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <HeatCapacity ptrID="', num2str(matVar+137), '" subjectID="', num2str(matVar+138), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </HeatCapacity>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ThermalConductivity ptrID="', num2str(matVar+139), '" subjectID="', num2str(matVar+140), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </ThermalConductivity>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <PerfusionByBlood ptrID="', num2str(matVar+141), '" subjectID="', num2str(matVar+142), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </PerfusionByBlood>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <MetabolicHeat ptrID="', num2str(matVar+143), '" subjectID="', num2str(matVar+144), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </MetabolicHeat>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <WaterRatio ptrID="', num2str(matVar+145), '" subjectID="', num2str(matVar+146), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Formula typeid="6" type="Double" value="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </WaterRatio>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </PhysicalParameters>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </PhysicalDetails>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '          </Material>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '        </MaterialDefinition>';
                            totalLineCounts = totalLineCounts+1;

                        matVar = matVar+147;
                end
            end
            if loopCount == floor(totalCells*perCount/10)
                fprintf('Material: %d / %d (%d%%)\n', loopCount, totalCells, perCount*10);
                perCount = perCount+1;
            end
            loopCount = loopCount+1;
        end
    end
end

save('registeredMat.mat', 'registeredMat');
save('memoMat.mat', 'memoMat');

outputCode(totalLineCounts,1) = readCode(matEndIndex-1,1);
    totalLineCounts = totalLineCounts+1;
outputCode(totalLineCounts,1) = readCode(matEndIndex,1);
    totalLineCounts = totalLineCounts+1;
    
convMatTime = toc(convMatTic);

%% convert Object
convObjTic = tic; perCount = 1;

switch KEEPMODEL
    case 0
        outputCode = vertcat(outputCode, readCode(matEndIndex+1:objBeginIndex+29,1));
        totalLineCounts = totalLineCounts+size(readCode(matEndIndex+1:objBeginIndex+29,1),1);
    case 1
        outputCode = vertcat(outputCode, readCode(matEndIndex+1:objEndIndex-2,1));
        totalLineCounts = totalLineCounts+size(readCode(matEndIndex+1:objEndIndex-2,1),1);
end

str = char(readCode(objBeginIndex+2,1));
CS_numberIndex = strfind(str, '"');
CS_masterID = str2double(str(CS_numberIndex(1)+1:CS_numberIndex(2)-1));
CS_subjectID = str2double(str(CS_numberIndex(3)+1:CS_numberIndex(4)-1));

objVar = 4e9; objPriorityIndex = 1; loopCount = 1;
for kk = ceil(length(cndSta(1,1,:))*(NUMERATOR-0.9999999999)/DENOMINATOR):floor(length(cndSta(1,1,:))*NUMERATOR/DENOMINATOR)
    for jj = 1:length(cndSta(1,:,1))
        for ii = 1:length(cndSta(:,1,1))
            if mesh(ii,jj,kk) ~= 99
                
%                 if ii == SLICE_x/MESHSIZE || jj == SLICE_y/MESHSIZE || kk == SLICE_z/MESHSIZE
%                     INVISIBLE = 0;
%                 else
%                     INVISIBLE = 1;
%                 end
                
                outputCode(totalLineCounts,1) = ['        <Part ptrID="', num2str(objVar), '" subjectID="', num2str(objVar+1), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '          <Model Unit="mm" sname="Cuboid">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '            <NamedAttributes>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '              <ReadWriteAttributes>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                <Attribute Name="MeshParameters">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                  <Properties Settings="Dependency" Type="remcom::MeshParameters">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+2), '" subjectID="', num2str(objVar+3), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                      <ModelMeshParameters SecondaryPriority="', num2str(objPriorityIndex), '"/>'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                    </AttributeData>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                  </Properties>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                </Attribute>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                <Attribute Name="GridGeneratorHelperParameters">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                  <Properties Settings="NoDependency" Type="remcom::GridGeneratorHelperParameters">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+4), '" subjectID="', num2str(objVar+5), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                      <PartGridGeneratorHelperParameters UseProGridGridRegions="true" FixedGridLocationBoundarySpecification="LowerX|LowerY|LowerZ|UpperX|UpperY|UpperZ|All" UseCustomProGridCellsPerWavelength="false" GridRegionsEnabled="false" FixedLocationsEnabled="false" FixPointExtractionOptions="C0VertexDiscontinuities|C1VertexDiscontinuities|GridAxisAlignedLineEndPoints" UseCustomProGridMinFeatureSize="false" UseCustomProGridNumberOfPaddingCells="false" GridRegionDirections="X|Y|Z" UseCustomProGridMinCellsAcrossFeature="false" ProGridGridRegionsEnabledWhenPartIsUnmeshed="false" UseCustomProGridBoundaryRefinementRatio="false" UseCustomProGridBoundaryRefinementNumberOfCells="false">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <GridRegionSpecification ptrID="', num2str(objVar+6), '" subjectID="', num2str(objVar+7), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <CellSizesSpecification>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <X MinimumType="RatioType">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="0.001"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="2"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            </X>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Y MinimumType="RatioType">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="0.001"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="2"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            </Y>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Z MinimumType="RatioType">';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="0.001"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </TargetSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              <MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Formula typeid="6" type="Double" value="2"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </MinimumSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            </Z>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </CellSizesSpecification>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </GridRegionSpecification>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        <ExtendAmount>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                          <Lower ptrID="', num2str(objVar+8), '" subjectID="', num2str(objVar+9), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Cartesian3DExpression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <x ptrID="', num2str(objVar+10), '" subjectID="', num2str(objVar+11), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </x>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <y ptrID="', num2str(objVar+12), '" subjectID="', num2str(objVar+13), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </y>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <z ptrID="', num2str(objVar+14), '" subjectID="', num2str(objVar+15), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </z>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            </Cartesian3DExpression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Lower>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                          <Upper ptrID="', num2str(objVar+16), '" subjectID="', num2str(objVar+17), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Cartesian3DExpression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <x ptrID="', num2str(objVar+18), '" subjectID="', num2str(objVar+19), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </x>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <y ptrID="', num2str(objVar+20), '" subjectID="', num2str(objVar+21), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </y>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                              <z ptrID="', num2str(objVar+22), '" subjectID="', num2str(objVar+23), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                  <Formula typeid="6" type="Double" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                                </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                              </z>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            </Cartesian3DExpression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Upper>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </ExtendAmount>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        <MinimumLoopSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Formula typeid="2" type="Int" value="0"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </MinimumLoopSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridMinFeatureSize ptrID="', num2str(objVar+24), '" subjectID="', num2str(objVar+25), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridMinFeatureSize>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridMinCellsAcrossFeature ptrID="', num2str(objVar+26), '" subjectID="', num2str(objVar+27), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Formula typeid="6" type="Double" value="5"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridMinCellsAcrossFeature>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridBoundaryRefinementRatio ptrID="', num2str(objVar+28), '" subjectID="', num2str(objVar+29), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Formula typeid="6" type="Double" value="3"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridBoundaryRefinementRatio>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridBoundaryRefinementNumberOfCells ptrID="', num2str(objVar+30), '" subjectID="', num2str(objVar+31), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Formula typeid="6" type="Double" value="3"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridBoundaryRefinementNumberOfCells>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridCellsPerWavelength ptrID="', num2str(objVar+32), '" subjectID="', num2str(objVar+33), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Formula typeid="6" type="Double" value="15"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridCellsPerWavelength>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = ['                        <CustomProGridNumberOfPaddingCells ptrID="', num2str(objVar+34), '" subjectID="', num2str(objVar+35), '">'];
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          <Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                            <Formula typeid="6" type="Double" value="3"/>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                          </Expression>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                        </CustomProGridNumberOfPaddingCells>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                      </PartGridGeneratorHelperParameters>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                    </AttributeData>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                  </Properties>';
                    totalLineCounts = totalLineCounts+1;
                outputCode(totalLineCounts,1) = '                </Attribute>';
                    totalLineCounts = totalLineCounts+1;

                switch INVISIBLE
                    case 0
                        outputCode(totalLineCounts,1) = '              </ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <ConstAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <Attribute Name="Material">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Properties Settings="DependencyExcludingValidity" Type="remcom::Material">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+36), '" subjectID="', num2str(memoMat(ii,jj,kk)+1), '" masterID="', num2str(memoMat(ii,jj,kk)), '"/>'];
% %                         outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+36), '" subjectID="', num2str(matVar_bak+147*(objPriorityIndex-1)+1), '" masterID="', num2str(matVar_bak+147*(objPriorityIndex-1)), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Properties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Attribute>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </ConstAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <CoordinateSystem ptrID="', num2str(objVar+37), '" subjectID="', num2str(objVar+38), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <CoordinateSystem PrimaryAxis="Z" SecondaryAxis="X">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <AnchorPoint ptrID="', num2str(objVar+39), '" subjectID="', num2str(objVar+40), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemPositionExpression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+41), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+54), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Position>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <x ptrID="', num2str(objVar+42), '" subjectID="', num2str(objVar+43), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(ii*MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </x>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <y ptrID="', num2str(objVar+44), '" subjectID="', num2str(objVar+45), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(jj*MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </y>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <z ptrID="', num2str(objVar+46), '" subjectID="', num2str(objVar+47), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
%                         outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str((kk*MESHSIZE-MESHSIZE/2)*1e-3), '"/>'];
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(((kk-1)*MESHSIZE)*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </z>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </Position>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemPositionExpression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </AnchorPoint>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <PrimaryDirection ptrID="', num2str(objVar+48), '" subjectID="', num2str(objVar+49), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+50), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+54), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Rotations x="0" y="0" z="1"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </PrimaryDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <SecondaryDirection ptrID="', num2str(objVar+51), '" subjectID="', num2str(objVar+52), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+53), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+54), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Rotations x="1" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </SecondaryDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <Translation x="0" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <OffsetOrientation Scalar="1">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Vector x="0" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </OffsetOrientation>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ReferenceCoordinateSystem ptrID="', num2str(objVar+54), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(CS_masterID), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </CoordinateSystem>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </CoordinateSystem>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            <Locators OwnsContents="true"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <ModelRecipe ptrID="', num2str(objVar+55), '" subjectID="', num2str(objVar+56), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <Recipe version="1" indexOfFailedFeature="-1" cachingEnabled="true">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ReferenceCoordinateSystem ptrID="', num2str(objVar+57), '" subjectID="', num2str(objVar+38), '" masterID="', num2str(objVar+37), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <Feature ptrID="', num2str(objVar+58), '" subjectID="', num2str(objVar+59), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Cuboid ResetIdentifiers="false" SuppressionCount="0" SolidOrSheetOption="CreateAsSolid">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      <ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Attribute Name="EditingStep">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          <Properties Settings="Dependency" Type="remcom::VariantAttribute">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                            <AttributeData ptrID="', num2str(objVar+60), '" subjectID="', num2str(objVar+61), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <VariantAttribute Variant="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </AttributeData>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Properties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Attribute>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+62), '" subjectID="', num2str(objVar+38), '" masterID="', num2str(objVar+57), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <x ptrID="', num2str(objVar+63), '" subjectID="', num2str(objVar+64), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </x>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <y ptrID="', num2str(objVar+65), '" subjectID="', num2str(objVar+66), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </y>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <z ptrID="', num2str(objVar+67), '" subjectID="', num2str(objVar+68), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </z>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Cuboid>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Feature>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </Recipe>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </ModelRecipe>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            <FacetOptions MaxGridLines="2000" FacetUnspecifiedFaces="true" SurfaceToleranceMode="RelativeToBodyDiagonal" GridToEdges="false" SurfaceTolerancePureNumber="1" MaxEdgeLength="0" SpecialCase="true" Quality="Legacy" NormalTolerance="30" MinGridLines="0" AllowRefacetFaces="true" RecalculatePCurves="false" SurfaceToleranceRelativeToDiagonal="0.002" NarrowRegionRepair="false" EdgeSagTolerance="0.5"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '          </Model>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '        </Part>';
                            totalLineCounts = totalLineCounts+1;

                        objVar = objVar+69;

                    case 1
                        outputCode(totalLineCounts,1) = '                <Attribute Name="VisibilityFlag">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Properties Settings="Dependency" Type="remcom::VariantAttribute">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+36), '" subjectID="', num2str(objVar+37), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      <VariantAttribute Variant="true"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </AttributeData>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Properties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Attribute>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <ConstAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <Attribute Name="Material">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Properties Settings="DependencyExcludingValidity" Type="remcom::Material">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+36), '" subjectID="', num2str(memoMat(ii,jj,kk)+1), '" masterID="', num2str(memoMat(ii,jj,kk)), '"/>'];
% %                         outputCode(totalLineCounts,1) = ['                    <AttributeData ptrID="', num2str(objVar+36), '" subjectID="', num2str(matVar_bak+147*(objPriorityIndex-1)+1), '" masterID="', num2str(matVar_bak+147*(objPriorityIndex-1)), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Properties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Attribute>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </ConstAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <CoordinateSystem ptrID="', num2str(objVar+39), '" subjectID="', num2str(objVar+40), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <CoordinateSystem PrimaryAxis="Z" SecondaryAxis="X">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <AnchorPoint ptrID="', num2str(objVar+41), '" subjectID="', num2str(objVar+42), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemPositionExpression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+43), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+56), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Position>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <x ptrID="', num2str(objVar+44), '" subjectID="', num2str(objVar+45), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(ii*MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </x>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <y ptrID="', num2str(objVar+46), '" subjectID="', num2str(objVar+47), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(jj*MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </y>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <z ptrID="', num2str(objVar+48), '" subjectID="', num2str(objVar+49), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str((kk*MESHSIZE-MESHSIZE/2)*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </z>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </Position>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemPositionExpression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </AnchorPoint>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <PrimaryDirection ptrID="', num2str(objVar+50), '" subjectID="', num2str(objVar+51), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+52), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+56), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Rotations x="0" y="0" z="1"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </PrimaryDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <SecondaryDirection ptrID="', num2str(objVar+53), '" subjectID="', num2str(objVar+54), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+55), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(objVar+56), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Rotations x="1" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </CoordinateSystemDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </SecondaryDirection>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <Translation x="0" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                <OffsetOrientation Scalar="1">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Vector x="0" y="0" z="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </OffsetOrientation>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ReferenceCoordinateSystem ptrID="', num2str(objVar+56), '" subjectID="', num2str(CS_subjectID), '" masterID="', num2str(CS_masterID), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </CoordinateSystem>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </CoordinateSystem>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            <Locators OwnsContents="true"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['            <ModelRecipe ptrID="', num2str(objVar+57), '" subjectID="', num2str(objVar+58), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              <Recipe version="1" indexOfFailedFeature="-1" cachingEnabled="true">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <ReferenceCoordinateSystem ptrID="', num2str(objVar+59), '" subjectID="', num2str(objVar+40), '" masterID="', num2str(objVar+39), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                <Feature ptrID="', num2str(objVar+60), '" subjectID="', num2str(objVar+61), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  <Cuboid ResetIdentifiers="false" SuppressionCount="0" SolidOrSheetOption="CreateAsSolid">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      <ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Attribute Name="EditingStep">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          <Properties Settings="Dependency" Type="remcom::VariantAttribute">';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                            <AttributeData ptrID="', num2str(objVar+62), '" subjectID="', num2str(objVar+63), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                              <VariantAttribute Variant="0"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                            </AttributeData>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                          </Properties>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Attribute>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </ReadWriteAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </NamedAttributes>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                    <ReferenceCoordinateSystem ptrID="', num2str(objVar+64), '" subjectID="', num2str(objVar+40), '" masterID="', num2str(objVar+59), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    <Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <x ptrID="', num2str(objVar+65), '" subjectID="', num2str(objVar+66), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </x>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <y ptrID="', num2str(objVar+67), '" subjectID="', num2str(objVar+68), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </y>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                      <z ptrID="', num2str(objVar+69), '" subjectID="', num2str(objVar+70), '">'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        <Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = ['                          <Formula typeid="6" type="Double" value="', num2str(MESHSIZE*1e-3), '"/>'];
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                        </Expression>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                      </z>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                    </Dimensions>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                  </Cuboid>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '                </Feature>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '              </Recipe>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            </ModelRecipe>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '            <FacetOptions MaxGridLines="2000" FacetUnspecifiedFaces="true" SurfaceToleranceMode="RelativeToBodyDiagonal" GridToEdges="false" SurfaceTolerancePureNumber="1" MaxEdgeLength="0" SpecialCase="true" Quality="Legacy" NormalTolerance="30" MinGridLines="0" AllowRefacetFaces="true" RecalculatePCurves="false" SurfaceToleranceRelativeToDiagonal="0.002" NarrowRegionRepair="false" EdgeSagTolerance="0.5"/>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '          </Model>';
                            totalLineCounts = totalLineCounts+1;
                        outputCode(totalLineCounts,1) = '        </Part>';
                            totalLineCounts = totalLineCounts+1;

                        objVar = objVar+71;
                end

                objPriorityIndex = objPriorityIndex+1;
            end
            if loopCount == floor(totalCells*perCount/10)
                fprintf('Object: %d / %d (%d%%)\n', loopCount, totalCells, perCount*10);
                perCount = perCount+1;
            end
            loopCount = loopCount+1;
        end
    end
end

outputCode = vertcat(outputCode, readCode(objEndIndex-1:codeLine-1,1));
totalLineCounts = totalLineCounts+size(readCode(objEndIndex-1:codeLine-1,1),1);

convObjTime = toc(convObjTic);

%% write
writeTic = tic; perCount = 1;

fileID = fopen('./Project.xml','w');
for i = 1:totalLineCounts-1
    output = char(outputCode(i));
    fprintf(fileID,'%s\n',output);
    
    if i == floor((totalLineCounts-1)*perCount/10)
        fprintf('Writing: %d / %d (%d%%)\n', i, totalLineCounts-1, perCount*10);
        perCount = perCount+1;
    end
end
fclose(fileID);

writeTime = toc(writeTic);
totalTime = toc(totalTic);

fprintf('\n== oߎ ==============================\n');
fprintf('ǂݍ:\t\t%f[sec]\n',loadTime);
fprintf('}eAϊ:\t%f[sec]\n',convMatTime);
fprintf('IuWFNgϊ:\t%f[sec]\n',convObjTime);
fprintf(':\t\t%f[sec]\n',writeTime);
fprintf('S:\t\t\t%f[sec]\n',totalTime);
fprintf('=========================================\n');

